# 求和练习

Joe 想要得到 orders 表

```mysql
create table orders (
                        id int primary key auto_increment,
                        item_id int,
                        amount int,
                        unit_price decimal(12, 4),
                        total decimal(12, 4),
                        description varchar(2000),
                        ts timestamp default now(),
                        deal bool default false
);
```

中所有单价(unit_price)超过 1000 的订单中，已成交（deal 为 true）的总值（total），这个查询应该是：

## 答案

```mysql
select sum(total) from orders where deal and unit_price > 1000;
```

## 选项

### A

```mysql
select sum(total) from orders where deal and unit_price > 1000;
```

### B

```mysql
select sum(total) from orders having deal and unit_price > 1000;
```

### C

```mysql
select sum(total) from orders group by deal having unit_price > 1000;
```

### D

```mysql
select sum(total) from orders having deal and unit_price > 1000;
```